cscript

set scheme stcolor

global logs logs
global png png

/*-----------------------------------------------------------------------------
	example 1	
-----------------------------------------------------------------------------*/
					//----------------------------//
					// load data
					//----------------------------//
sjlog using $logs/ex1_1, replace 
webuse assets3
global catecovars age educ i.(incomecat pension married twoearn ira ownhome)

global fvars incomecat pension married twoearn ira ownhome
global controls c.(educ age)#i.($fvars)
sjlog close, replace

					//----------------------------//
					// cate
					//----------------------------//
sjlog using $logs/ex1_2, replace
cate po (assets $catecovars) (e401k), rseed(12345671) controls($controls) nolog
sjlog close, replace

					//----------------------------//
					// categraph iateplot
					//----------------------------//
sjlog using $logs/ex1_3, replace
categraph histogram
sjlog close, replace
graph export $png/ex1_g1.png, replace

					//----------------------------//
					// estat heterogeneity
					//----------------------------//
sjlog using $logs/ex1_4, replace
estat heterogeneity
sjlog close, replace

					//----------------------------//
					// estat projection
					//----------------------------//
sjlog using $logs/ex1_5, replace
estat projection
sjlog close, replace

					//----------------------------//
					// categraph iateplot
					//----------------------------//
sjlog using $logs/ex1_6, replace
categraph iateplot educ
sjlog close, replace
graph export $png/ex1_g2.png, replace

					//----------------------------//
					// estat series
					//----------------------------//
sjlog using $logs/ex1_7, replace
estat series educ, graph
sjlog close, replace
graph export $png/ex1_g3.png, replace

/*-----------------------------------------------------------------------------
	Example 2: GATE	
-----------------------------------------------------------------------------*/
					//----------------------------//
					// GATE
					//----------------------------//
sjlog using $logs/ex2_1, replace
cate aipw (assets $catecovars) (e401k), rseed(12345671) ///
	controls($controls) group(incomecat) nolog
sjlog close, replace

					//----------------------------//
					// gateplot
					//----------------------------//
sjlog using $logs/ex2_2, replace
categraph gateplot
sjlog close, replace
graph export $png/ex2_g1.png, replace

					//----------------------------//
					// gatetest
					//----------------------------//
sjlog using $logs/ex2_3, replace
estat gatetest
sjlog close, replace


/*-----------------------------------------------------------------------------
	Example 3: GATES	
-----------------------------------------------------------------------------*/
					//----------------------------//
					// gates
					//----------------------------//
sjlog using $logs/ex3_1, replace
cate aipw (assets $catecovars) (e401k), rseed(12345671) ///
	controls($controls) group(4) nolog
sjlog close, replace

					//----------------------------//
					// gateplot
					//----------------------------//
sjlog using $logs/ex3_2, replace
categraph gateplot
sjlog close, replace
graph export $png/ex3_g1.png, replace

					//----------------------------//
					// gatetest
					//----------------------------//
sjlog using $logs/ex3_3, replace
estat gatetest 1 4
sjlog close, replace
					//----------------------------//
					// classification
					//----------------------------//
sjlog using $logs/ex3_4, replace
estat classification ownhome

estat classification age
sjlog close, replace

/*-----------------------------------------------------------------------------
	example 4: policy evaluation	
-----------------------------------------------------------------------------*/
					//----------------------------//
					// load data
					//----------------------------//
sjlog using $logs/ex4_1, replace
webuse lung, clear

global cvars bmip heightp o2amt lungals centervol walkdist 	///
	bmid heightd distd lungpo2 hratio ischemict
global fvars diabetesp karn racep sexp lifesvent assisvent 	///
	o2rest raced smoked cmv deathcause diabetesd 		///
	expandd sexd lungalloc genderm racem

global controls c.($cvars)#i.($fvars)

global catecovars c.($cvars) i.($fvars)
sjlog close, replace


					//----------------------------//
					// cate
					//----------------------------//
sjlog using $logs/ex4_2, replace
cate aipw (fev1p $catecovars) (transtype), rseed(12345671) 	///
	controls($controls) nolog 
sjlog close, replace

					//----------------------------//
					// replicate ATE
					//----------------------------//
sjlog using $logs/ex4_3, replace
generate treatall = 1
generate treatnone = 0

estat policyeval treatall treatnone
sjlog close, replace

					//----------------------------//
					// hypothetical policy
					//----------------------------//
sjlog using $logs/ex4_4, replace
generate policy1 = walkdist > 500 & !diabetesp & !missing(walkdist)

estat policyeval policy1 transtype
sjlog close, replace

