****************************************************
*Do file produced to illustrate the capabilities of:
* ilt, ownchild, and leslie
* Written by Jeronimo Muniz, PhD, 26 Feb. 2026
* 2026 Stata Biostatistics and Epidemiology Simposyum 
****************************************************
******************
*ilt presentation
******************
net describe st0729, from(http://www.stata-journal.com/software/sj23-3)
net install st0729
net get st0729

help ilt
use pop_vietnam.dta, replace
list, noobs sep(17)

*Census-, death-based, and iterative procedure with graph of life expectancies
ilt, interval(10) census death iterative residual life

*Graph of projected populations using four methods
qui ilt, interval(10) census death iterative proj

*Ratio of observed to projected populations using four methods
qui ilt, interval(10) census death iterative ratio

**********************
*ownchild presentation
**********************
help ownchild
run ownchild.ado
use br2010_sample.dta, replace //5% stratified sample from IPUMS-International
des

*Fertility estimates since 1996, with graph
ownchild [iw=perwt], place(Brazil) year(2010) summary

*Fertility estimates using the same survival probabilities for all races 
drop if race==30 | race==40 | race==99
bysort race: ownchild [iw=perwt], pl(Brazil) y(2010) period(5) exact

*Race-specific fertility (with race-specific survival)
ownchild, p_children(pkids_race.dta) p_female(pfemale_race.dta) by(race) manualx

********************
*leslie presentation
********************
help leslie
mata mata clear
run leslie.ado

use sweden_1993_bothsexes.dta, replace
des
list, sep(18) noobs

db leslie

*Two-sex projection assuming constant fertility and mortality 25 years forward
leslie, period(5) two stable summary

*Two-sex projection assuming the fertility standard and future life expectancy from the UN WPP (2024) median probabilistic variant
leslie, period(7) two base(1993) place(Sweden) surv(. .)

*Alternative fertility and mortality scenarios
leslie, period(7) two base(1993) fert(3) surv(85 82)

*Including constant migration rates residually calculated
leslie, p(7) two base(1993) fert(3) surv(85 82) mig1(Sweden_1988_bothsexes.dta) gr(nodraw)

*Multistate projections
use multi_race_brazil.dta, replace
des
l, noobs sepby(state)

*Multistate projections assuming constant transition rates over time + summary multistate measures 
leslie, p(6) multistate su

*Counterfactual scenario for multistate projections without mobility
leslie, p(6) multi nomobility

