**# Linear regression

use math, clear

codebook

regress math i.schtype, base

set showbaselevels on, permanently 

mixed math i.schtype

mixed math i.schtype homework

mixed math schtype##c.homework

margins schtype, at(homework=(1/5))

marginsplot

predict yhat1

twoway (scatter math homework)

twoway (scatter math homework) (line yhat1 homework, connect(ascending))

list schid math schtype homework if (schid==6327 | schid==72991), sepby(schid) noobs

**# The multilevel/mixed model

mixed math schtype##c.homework || schid: , nolog

predict yhat2_fe
predict yhat2, fitted

twoway (scatter math homework) (line yhat2 homework, connect(ascending)) ///
	(line yhat2_fe homework, connect(ascending) lwidth(thick))
	
mixed math schtype##c.homework || schid: homework , nolog

predict yhat3_fe
predict yhat3, fitted

twoway (scatter math homework) (line yhat3 homework, connect(ascending)) ///
	(line yhat3_fe homework, connect(ascending) lwidth(thick))
	
mixed math schtype##c.homework || schid: homework , covariance(unstructured) nolog

estat sd

**## ICC

mixed math || schid: , nolog
estat icc

mixed math homework || schid: , nolog
estat icc

mixed math homework i.schtype || schid: , nolog
estat icc

**## Disaggregated model

mixed math homework || schid: , nolog

estimates store conflated

bysort schid: egen HWb = mean(homework)

generate HWw = homework - HWb

mixed  math HWb HWw || schid: , nolog

estimates store wb

etable, estimates(conflated wb) column(estimates)

**# Exercise
*1
use patient, clear
codebook

*2
/*patients < doctors
doctor specifies cluster
minutes and satisfaction vary at level 1 (patient-level) 
female varies at level 2 (doctor-level) */

*3
mixed satisfaction || doctor:
estat icc

*4
mixed satisfaction c.minutes##female || doctor: minutes, covariance(unstructured)
estat sd

*5
bysort doctor: egen minutesB = mean(minutes)
generate minutesW = minutes - minutesB
mixed satisfaction c.minutesW##female minutesB || doctor: minutesW, covariance(unstructured)


