
** Introduction to automated tables using collect
** Training session - 2025 Belgium Stata Conference
** Nick Deschacht - nick.deschacht@kuleuven.be

cd " "


*********** Example 1
sysuse nlsw88, clear
collect clear

collect: bysort race married: summarize wage

collect style cell, nformat(%5.2f) font(Garamond, size(10))
collect style cell border_block, border(right, pattern(nil))
collect title "Table. Mean wages by race and married"
collect style putdocx, width(8cm) halign(center)

collect layout (race[1 2]) (married) (result[mean])
collect export meanwages.docx, replace


**************  useful collect commands: 
collect layout (race#married) (result[mean sd])

collect dir
collect dims
collect levelsof result



*********** Example 2: mean comparisons and t tests 
sysuse nlsw88, clear
collect clear

foreach v of varlist wage age grade {
	collect, tag(variable[`v']): ttest `v', by(married)
}

collect label levels result mu_1 "Single" mu_2 "Married" p "p value", modify
collect style cell result[mu_1 mu_2], nformat(%6.1f)
collect style cell result[p], nformat(%6.3f)
collect title "Table. Mean characteristics of single and married respondents"
collect style cell, font(Garamond, size(10))
collect style cell border_block, border(right, pattern(nil))
collect style putdocx, width(8cm) halign(center)

collect layout (variable) (result[mu_1 mu_2 p])
collect export meancomparison.docx, replace



*********** Example 3 (Table with descriptive statistics)
sysuse nlsw88, clear
collect clear

tabulate race, generate(race_)
foreach v of varlist wage age grade race_* {
	collect, tag(variable[`v']): summarize `v'
}

collect style cell result[mean sd], nformat(%6.2f)
collect style cell variable[wage]#result[min max], nformat(%6.2f)
collect label levels variable race_1 "race: white" race_2 "race: black" race_3 "race: other"
collect label levels result N "N" sd "SD" min "Min" max "Max", modify
collect style cell border_block, border(right, pattern(nil))
collect title "Table 1. Descriptive statistics"
collect style title, font(Times New Roman, size(11))
collect style cell, font(Garamond, size(10))

collect style putdocx, width(10cm) width(25, 15, 15, 15, 15, 15) halign(center)

collect layout (variable) (result[N mean sd min max])
collect export table1.docx, replace




*********** Example 4. Regression models
sysuse nlsw88, clear
collect clear

collect: regress wage grade age 
collect: regress wage grade age i.race

collect style cell result[_r_se], sformat("(%s)")
collect style header result[_r_b _r_se], level(hide)
collect stars _r_p 0.001 "***" 0.01 "**" 0.05 "*", attach(_r_b) shownote
collect style showbase off

collect style column, extraspace(2)
collect style row stack, nobinder
collect style note, font(Times New Roman, size(9))
collect label levels cmdset 1 "Model 1" 2 "Model 2"
collect label levels result N "N", modify
collect label levels colname grade "Grade" age "Age" _cons "Constant", modify
collect title "Table 3. Regression models"
collect style title, font(Times New Roman, size(11))
collect style cell, nformat(%9.3f)
collect style cell result[N], nformat(%9.0f)
collect style cell, font(Garamond, size(10))
collect style cell border_block, border(right, pattern(nil))
collect style cell result[N], border(top)
collect style putdocx, width(10cm) width(50, 25, 25) halign(center)
collect style cell cell_type[item column-header], halign(center)

collect layout (colname#result[_r_b _r_se] result[N r2]) (cmdset) 
collect export regression.docx, replace


